use strict;
use warnings FATAL => 'all';

use Test::More;

use lib::abs qw(
    ../lib
);
use Utils;

sub main_in_test {
    pass('Loaded ok');

    my $tests = [
        {
            content => "1\n2\n3\n",
            lines => undef,
            expected => "1\n2\n3\n",
        },
        {
            content => "1\n2\n3\n",
            lines => 1,
            expected => "3\n",
        },
        {
            content => "1\n2\n3\n",
            lines => 2,
            expected => "2\n3\n",
        },
        {
            content => "1\n2\n3\n",
            lines => 100,
            expected => "1\n2\n3\n",
        },
    ];

    foreach my $t (@{$tests}) {
        is(
            get_last_lines_from_content(
                content => $t->{content},
                lines => $t->{lines},
            ),
            $t->{expected},
        );
    }

    done_testing();
}
main_in_test();
__END__
