use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;

use lib::abs qw(
    ../lib
);
use Utils;

sub main_in_test {

    pass('Loaded ok');

    my $valid = [
        {
            backend => 'v2.18',
            frontend => 'master',
            db => 'dev',
            blackbox => 'http://blackbox-mimino.yandex.net',
        },
        {
            backend => 'v2.18',
            frontend => 'master',
            db => 'dev',
            blackbox => 'http://blackbox-mimino.yandex.net',
            comment => '123',
        },
    ];

    my $not_valid = [
        {
            frontend => 'master',
            # no backend
            db => 'dev',
        },
        {
            # no frontend
            backend => 'v2.18',
            db => 'dev',
        },


# TODO - for some strange reason additionalProperties in perl lib JSV does
# work on my mac book, but does not work on dev-partner2. Need to fix it.
#        {
#            backend => 'v2.18',
#            frontend => 'master',
#            db => 'dev',
#
#            # uknown property
#            mememe => 4,
#        },
    ];

    foreach my $el (@{$valid}) {
        my $result = is_valid_user_input_for_beta_creation($el);
        ok($result);
    }

    foreach my $el (@{$not_valid}) {
        my $result = is_valid_user_input_for_beta_creation($el);
        ok(!$result);
    }

    done_testing();

}
main_in_test();
__END__
