use strict;
use warnings FATAL => 'all';
use feature 'say';
use utf8;
use open qw(:std :utf8);

use Test::More;

use lib::abs qw(
    ../lib
);
use Utils;

sub main_in_test {

    pass('Loaded ok');

    my $not_valid = [
        {
            input => { ttl => 'asdf' },
            expected_description => '"ttl" must be a number',
        },
        {
            input => { ttl => -1 },
            expected_description => '"ttl" must be in range [0, 31536000]',
        },
        {
            input => { ttl => 31536001 },
            expected_description => '"ttl" must be in range [0, 31536000]',
        },
    ];

    foreach my $el (@{$not_valid}) {
        my ($result, $description) = is_valid_user_input_for_beta_creation_version_3($el->{input});
        ok(!$result, 'got expected error flag');
        is($description, $el->{expected_description}, $el->{expected_description});
    }

    done_testing();

}
main_in_test();
__END__
