use Test::More;
use Test::Mojo;
use File::Slurp;
use JSON::XS;

$ENV{BETA_HOST} = 'docker';

require "app.psgi";

our $T = Test::Mojo->new;

sub check_status_is {
    my ($status) = @_;

    my %common = (
        backend => 'master',
        backend_sha1 => '123',
        backend_status => 'deleted',
        frontend => 'master',
        frontend_sha1 => '123',
        frontend_status => 'deleted',
    );

    $T->get_ok('/api/3/betas/8501')
        ->status_is(200)
        ->json_is({ %common, status => $status } )
        ;

}

$T->ua->max_redirects(1);

note 'mocking docker-compose';
write_file('/usr/local/bin/docker-compose', '');

note 'creating mock for beta 8501';
`mkdir -p /local/creator/8501`;
write_file '/local/creator/meta/8501.json', encode_json {
    backend => 'master',
    backend_sha1 => '123',
    frontend => 'master',
    frontend_sha1 => '123',
    status => 'running',
};

check_status_is('running');

$T->put_ok('/api/3/betas/8501/action/stop')->status_is(200);
check_status_is('stopped');

$T->put_ok('/api/3/betas/8501/action/stop')->status_is(200);
check_status_is('stopped');

$T->put_ok('/api/3/betas/8501/action/start')->status_is(200);
check_status_is('running');

$T->put_ok('/api/3/betas/8501/action/start')->status_is(200);
check_status_is('running');

$T->put_ok('/api/3/betas/8501/action/xxx')->status_is(404);
check_status_is('running');

# 404 on not running beta
$T->put_ok('/api/3/betas/8502/action/stop')->status_is(404);

note 'removing mock for beta 8501';
`rm -rf /local/creator/8501`;
unlink '/local/creator/meta/8501.json';

done_testing();
