use strict;
use warnings FATAL => 'all';

use Test::More;
use File::Temp;
use File::Slurp;

use lib::abs qw(
    ../lib
);
use Utils;

sub main_in_test {
    pass('Loaded ok');

    my $original = '
FROM node:4.3.0

RUN git clone https://github.yandex-team.ru/partner/yharnam.git /var/www/ && git checkout -b tmp 0.0.174

RUN make beta
';

    my $expected = '
FROM node:4.3.0

RUN git clone https://github.yandex-team.ru/partner/yharnam.git /var/www/ && git checkout -b tmp ABC

RUN make beta
';

    is(
        switch_frontend($original, 'ABC'),
        $expected,
    );

    done_testing();
}
main_in_test();

__END__
