function deleteBeta(port) {
    var result = confirm('Удалить бету ' + port + '?');

    if (result) {
        $.ajax({
            url: '/api/3/betas/' + port,
            type: 'DELETE',
            success: function(result) {
                location.reload();
            }
        });
    }
}

function createBeta() {

    $("#createButton").prop("disabled",true);
    $("#createButton").prop('value', 'Создаю');

    var data = $('#addForm').serializeObject();

    var port = data.port;

    var body = {};
    body.ubuntu_version = data.ubuntu_version;
    body.backend = data.backend;
    body.frontend = data.frontend;

    if (data.comment.length > 0) {
        body.comment = data.comment;
    }

    body.db = { type: 'preset', preset_id: data.db };
    body.ttl = (data.ttl_hours ||= 24) * 60*60;
    body.blackbox = { type: 'url', url: data.blackbox };
    body.yacotools = { type: 'url', url: data.yacotools };
    body.bs = { type: 'url', url: data.bs };

    $.ajax({
        url: '/api/3/betas/' + port,
        type: 'PUT',
        data : JSON.stringify(body),
        contentType : 'application/json',
        success: function(result) {
            $("#createButton").prop("disabled",false);
            window.location.replace("/");
        },
        error: function (request, status, error) {
            alert( status + ' — ' + error);
        }
    });

}

// http://stackoverflow.com/questions/1184624/convert-form-data-to-javascript-object-with-jquery
$.fn.serializeObject = function()
{
    var o = {};
    var a = this.serializeArray();
    $.each(a, function() {
        if (o[this.name] !== undefined) {
            if (!o[this.name].push) {
                o[this.name] = [o[this.name]];
            }
            o[this.name].push(this.value || '');
        } else {
            o[this.name] = this.value || '';
        }
    });
    return o;
};
