
use strict;
use warnings FATAL => 'all';

use Utils;

use Test::More;
use Test::Deep;

my @tests = (
    {
        name => 'Ничего удалять не нужно (количество образов не превышает max_left)',
        input => {
            current_images => [qw(
                registry.partner.yandex-team.ru/partner2-db-2017-03-25
                registry.partner.yandex-team.ru/partner2-db-2017-03-26
            )],
            max_left => 2,
        },
        expected_output => [],
    },
    {
        name => 'Нужно удалить старые образы, которые превышают max_left',
        input => {
            current_images => [qw(
                registry.partner.yandex-team.ru/partner2-db-2017-03-23
                registry.partner.yandex-team.ru/partner2-db-2017-03-24
                registry.partner.yandex-team.ru/partner2-db-2017-03-25
                registry.partner.yandex-team.ru/partner2-db-2017-03-26
            )],
            max_left => 2,
        },
        expected_output => [qw(
            registry.partner.yandex-team.ru/partner2-db-2017-03-23
            registry.partner.yandex-team.ru/partner2-db-2017-03-24
        )],
    },
    {
        name => 'Из ТЗ st/INFRASTRUCTUREPI-1968 - "безусловно удалять образ если есть более свежий с тем же тагом"',
        input => {
            current_images => [qw(
                registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-25
                registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-26
            )],
            max_left => 10,
        },
        expected_output => [qw(
            registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-25
        )],
    },
    {
        name => 'Удаление старых образов с тегом',
        input => {
            current_images => [qw(
                registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-23
                registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-24
                registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-25
                registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-26
            )],
            max_left => 10,
        },
        expected_output => [qw(
            registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-23
            registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-25
        )],
    },
    {
        name => 'Удаление старых образов',
        input => {
            current_images => [qw(
                registry.partner.yandex-team.ru/partner2-db-2017-03-19
                registry.partner.yandex-team.ru/partner2-db-2017-03-20
                registry.partner.yandex-team.ru/partner2-db-2017-03-21
                registry.partner.yandex-team.ru/partner2-db-2017-03-22
                registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-23
                registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-24
                registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-25
                registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-26
            )],
            max_left => 5,
        },
        expected_output => [qw(
            registry.partner.yandex-team.ru/partner2-db-2017-03-19
            registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-23
            registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-25
        )],
    },
    {
        name => 'Удаление старых образов (проверка что все работает и в случае неотсортированных образов)',
        input => {
            current_images => [qw(
                registry.partner.yandex-team.ru/partner2-db-2017-03-22
                registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-25
                registry.partner.yandex-team.ru/partner2-db-2017-03-21
                registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-24
                registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-26
                registry.partner.yandex-team.ru/partner2-db-2017-03-20
                registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-23
                registry.partner.yandex-team.ru/partner2-db-2017-03-19
            )],
            max_left => 5,
        },
        expected_output => [qw(
            registry.partner.yandex-team.ru/partner2-db-2017-03-19
            registry.partner.yandex-team.ru/partner2-db-2.18.546-2017-03-23
            registry.partner.yandex-team.ru/partner2-db-2.18.547-2017-03-25
        )],
    },

);

foreach my $t (@tests) {
    my $got = [get_images_to_delete(%{$t->{input}})];
    my $result = cmp_bag($got, $t->{expected_output}, $t->{name});

    if ($result == 0) {
        diag('Got:');
        diag(Dumper($got));
        diag('Expected:');
        diag(Dumper($t->{expected_output}));
    }
}

done_testing();
