package Utils;

use strict;
use warnings FATAL => 'all';

use DBI;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
    get_dbh
);
our @EXPORT = @EXPORT_OK;

my $DBH = {};

=head2 get_dbh

    my $dbh_partner = get_dbh('partner');

=cut

sub get_dbh {
    my ($db, $force_reconnect) = @_;

    die 'no db' unless $db;

    if ($force_reconnect || !$DBH->{$db} || !$DBH->{$db}->ping()) {
        my $db_opts = _get_db_opts();

        my $dsn = sprintf(
            'DBI:mysql:database=%s;host=%s;port=%s',
            $db,
            $db_opts->{host},
            $db_opts->{port},
        );

        $DBH->{$db} = DBI->connect(
            $dsn,
            $db_opts->{user},
            $db_opts->{password},
            {
                PrintError => 0,
                RaiseError => 1,
                mysql_auto_reconnect => 0,
                mysql_enable_utf8 => 1,

                mysql_connect_timeout => 3,
                mysql_write_timeout => 3,
                mysql_read_timeout => 3,
            },
        ) or die "Can't connect to database. Error: " . $DBI::errstr . " . Stopped";
    }

    return $DBH->{$db};
}

sub _get_db_opts {

    my $db_opts = {
        host       => $ENV{DB_HOST},
        port       => $ENV{DB_PORT},
        user       => $ENV{DB_USER},
        password   => $ENV{DB_PASSWORD},
    };

    return $db_opts;
}

1;
