#!/usr/bin/perl

use strict;
use warnings;

use Mojolicious::Lite;
plugin JSONP => callback => 'callback';

use lib::abs -soft => qw(../lib ../lib_ext );

use Controller::CustomPages qw(
    get_backend_people_page
    get_frontend_people_page
    get_code_review_page
    get_homepage
    get_partner2_production_version_page
    get_partner2_ts_version_page
    get_release_tickets_page
    get_repo_pull_requests_page
    get_slack_release_channel_message_page
    get_update_release_tickets_cache_page
    get_update_repo_pull_requests_cache_page
    get_curry2tickets_page
);
use Model::CodeReview qw( get_review_page );
use Model::Hosts qw(
    get_all_host_names
    get_creator_host_names
    get_prod_host_names
    get_all_host_names_with_dc
);

####
main();
#####

sub main {

    set_routes();

    app->start;
}

sub set_routes{

    get '/' => \&get_homepage;

    get '/code-review' => sub {get_code_review_page($_[0], [ 'partner2' ])};
    get '/code-review-backend' => sub {get_code_review_page($_[0], [ 'partner2', 'form', 'page_id_generator', 'partner2-juggler-api', 'partner2-juggler-checks-dev', 'partner_ansible' ], 'backend')};
    get '/code-review-frontend' => sub {get_code_review_page($_[0], [ 'yharnam', 'form' ], 'frontend')};
    get '/code-review-form' => sub {get_code_review_page($_[0], [ 'form' ])};

    get '/api/0/creator_hosts.json' => sub {$_[0]->render_jsonp(get_creator_host_names())};
    get '/api/0/all_hosts.json' => sub {$_[0]->render_jsonp(get_all_host_names())};
    get '/api/0/all_hosts_with_dc.json' => sub {$_[0]->render_jsonp(get_all_host_names_with_dc())};
    get '/api/0/prod_hosts.json' => sub {$_[0]->render_jsonp(get_prod_host_names())};

    get '/api/0/release_tickets' => \&get_release_tickets_page;
    get '/api/0/update_release_tickets' => \&get_update_release_tickets_cache_page;
    post '/api/0/update_release_tickets' => \&get_update_release_tickets_cache_page;

    get '/api/0/partner2_pr' => sub {get_repo_pull_requests_page($_[0], 'partner2')};
    get '/api/0/update_partner2_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'partner2')};
    post '/api/0/update_partner2_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'partner2')};

    get '/api/0/yharnam_pr' => sub {get_repo_pull_requests_page($_[0], 'yharnam')};
    get '/api/0/update_yharnam_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'yharnam')};
    post '/api/0/update_yharnam_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'yharnam')};

    get '/api/0/form_pr' => sub {get_repo_pull_requests_page($_[0], 'form')};
    get '/api/0/update_form_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'form')};
    post '/api/0/update_form_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'form')};

    get '/api/0/page_id_generator_pr' => sub {get_repo_pull_requests_page($_[0], 'page_id_generator')};
    get '/api/0/update_page_id_generator_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'page_id_generator')};
    post '/api/0/update_page_id_generator_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'page_id_generator')};

    get '/api/0/partner2-juggler-api_pr' => sub {get_repo_pull_requests_page($_[0], 'partner2-juggler-api')};
    get '/api/0/update_partner2-juggler-api_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'partner2-juggler-api')};
    post '/api/0/update_partner2-juggler-api_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'partner2-juggler-api')};

    get '/api/0/partner2-juggler-checks-dev_pr' => sub {get_repo_pull_requests_page($_[0], 'partner2-juggler-checks-dev')};
    get '/api/0/update_partner2-juggler-checks-dev_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'partner2-juggler-checks-dev')};
    post '/api/0/update_partner2-juggler-checks-dev_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'partner2-juggler-checks-dev')};

    get '/api/0/partner_ansible_pr' => sub {get_repo_pull_requests_page($_[0], 'partner_ansible')};
    get '/api/0/update_partner_ansible_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'partner_ansible')};
    post '/api/0/update_partner_ansible_pr' => sub {get_update_repo_pull_requests_cache_page($_[0], 'partner_ansible')};

    get '/api/0/backend_people.json' => \&get_backend_people_page;
    get '/api/0/frontend_people.json' => \&get_frontend_people_page;

    get '/curry2tickets.json' => \&get_curry2tickets_page;

    get '/partner2_production_version.json' => \&get_partner2_production_version_page;
    get '/partner2_ts_version.json' => \&get_partner2_ts_version_page;

    post '/slack_release_channel_message' => \&get_slack_release_channel_message_page;

    return 1;
}
