package Controller::CustomPages;

use utf8;
use strict;
use warnings;

use Storable;
use Clone qw(clone);

use base qw/ Exporter /;
our @EXPORT_OK = qw(
    get_backend_people_page
    get_frontend_people_page
    get_code_review_page
    get_homepage
    get_partner2_production_version_page
    get_partner2_ts_version_page
    get_release_tickets_page
    get_repo_pull_requests_page
    get_slack_release_channel_message_page
    get_update_release_tickets_cache_page
    get_update_repo_pull_requests_cache_page
    get_curry2tickets_page
);

use Model::CodeReview;
use Utils::Common qw(
    get_tt
    get_backend_people
    get_frontend_people
);

use Model::Hosts qw(
    get_all_hosts
    get_all_host_names
    get_prod_host_names
    get_creator_host_names
);

use Model::PullRequest qw( get_repo_pull_requests_cached  update_repo_pull_requests_cache );
use Model::ReleaseTickets;
use Model::Slack;
use Model::Wiki;
use Model::BuildVersion;


sub get_update_repo_pull_requests_cache_page {
    my ($c, $repo) = @_;
    my $data = update_repo_pull_requests_cache($repo);
    $c->render(
        json => {
            success => JSON::PP::true,
            $c->req->param('with_data')
                ? (data => $data)
                : ()
        },
    );
};

sub get_update_release_tickets_cache_page {
    my ($c) = @_;
    my $data = Model::ReleaseTickets::update_release_tickets_cache();
    $c->render(
        json => {
            success => JSON::PP::true,
            $c->req->param('with_data')
                ? (data => $data)
                : ()
        },
    );
};

sub get_slack_release_channel_message_page{
    my $c = shift;

    my $mesage = $c->req->body;
    Model::Slack::send_message_to_release_channel( $mesage );

    $c->render( json => { success => JSON::PP::true } );
}


sub get_backend_people_page {
    my ($c, $repo) = @_;
    my $data = get_backend_people();
    $c->render( json => $data );
};

sub get_frontend_people_page {
    my ($c, $repo) = @_;
    my $data = get_frontend_people();
    $c->render( json => $data );
};

sub get_release_tickets_page {
    my ($c) = @_;
    my $content_ref = Model::ReleaseTickets::get_release_tickets_cached();
    $c->render( text => $$content_ref );
};

sub get_repo_pull_requests_page {
    my ($c, $repo ) = @_;
    my $content_ref = get_repo_pull_requests_cached($repo);
    $c->render( text => $$content_ref );
};

sub get_code_review_page{
    my ($c, $repos, $team) = @_;

    my $tables = Model::CodeReview::get_repo_code_review_data(
        $repos, $team,
        assignee  => $c->param('assignee'),
        author    => $c->param('author'),
        login     => $c->param('login'),
        not_today => $c->param('not_today'),
        start_id  => $c->param('start_id'),
    );

    my $page_template='';

    my $tt = get_tt();
    $tt->process(
        '/app/templates/code_review.tt2',
        {
            tables => $tables,
            repos =>  $repos,
        },
        \$page_template,
        { binmode => 1 }
    ) || die $tt->error(), "\n";

    $c->render(
        text => $page_template
    );
}

sub get_curry2tickets_page{
    my $c = shift;
    my $data = Model::Wiki::get_curry2tickets();

    $c->res->headers->header('Access-Control-Allow-Origin' => '*');
    $c->render_jsonp($data);
}

sub get_homepage {
    my $c = shift;

    my $hosts = get_all_hosts();

    my %tag2hosts;
    foreach my $h (@$hosts) {
        for my $t (@{$h->{tag}}) {
            push @{$tag2hosts{$t}}, $h;
        }
    }

    my $tags_data = [];
    foreach my $name (sort keys %tag2hosts) {
        my $hosts = [];
        foreach my $h (@{$tag2hosts{$name}}) {
            ( my $host = $h->{hostname} ) =~ s/\./_/g;
            push @$hosts, $host;
        }

        push @$tags_data, {
            name => $name,
            hosts => $hosts
        };
    }

    my $page_template='';

    my $tt = get_tt();
    $tt->process(
        '/app/templates/homepage.tt2',
        {
            tags => $tags_data,
        },
        \$page_template,
        { binmode => 1 }
    ) || die $tt->error(), "\n";


    $c->render(
        text => $page_template
    );

}

sub get_partner2_production_version_page{
    my $c = shift;

    my $prod_hosts = get_prod_host_names(with_type => 1);

    my $versions = {};

    for my $h (sort keys %$prod_hosts) {
        eval {
            $versions->{$h} = Model::BuildVersion::get_versions_from_host($h, $prod_hosts->{$h});
            $versions->{s} = $versions->{$h}{s} unless $versions->{s};
            $versions->{f} = $versions->{$h}{f} unless $versions->{f};
            $versions->{j} = $versions->{$h}{j} unless $versions->{j};
        };
    }

    return $c->render_jsonp( $versions );
}

sub get_partner2_ts_version_page{
    my $c = shift;
    return $c->render_jsonp(
        Model::BuildVersion::get_versions_from_host('partner2-test.yandex.ru')
    );
}




1;
