package Model::BuildVersion;

use utf8;
use strict;
use warnings;

use JSON::PP qw( decode_json );
use HTTP::Tiny;

sub get_versions_from_host {
    my ($host, $type) = @_;

    my %params;
    my $schema = 'https';
    if ($type && $type eq 'deploy') {
        $schema = 'http';
        $params{headers} = {
            'X-Real-Scheme' => 'https',
            'X-Real-Port'   => '443',
        };
    }

    my $versions = {
        s => decode_json(HTTP::Tiny->new()->get("$schema://$host/intapi/devel/version.json?lang=ru", \%params)->{content})->{data},
        f => decode_json(HTTP::Tiny->new()->get("$schema://$host/v2/devel/version",\%params)->{content})->{data},
        j => decode_json(HTTP::Tiny->new()->get("$schema://$host/java/version",\%params)->{content})->{data},
    };

    return $versions;
}

1;