package Model::PullRequest;

use utf8;
use strict;
use warnings;

use base qw/ Exporter /;
our @EXPORT_OK = qw(
    get_repos_pull_requests
    get_repo_pull_requests
    get_repo_pull_requests_cached
    update_repo_pull_requests_cache
);

use File::Slurp qw( read_file  write_file );
use JSON::PP qw( decode_json );
use HTTP::Tiny;
use Partner::PR;
use Utils::Common qw(
    get_startrek
    to_pretty_json
);

our $REPO_PR_DATA_FILE_PATH_TEMPLATE = '/data/%s_pr.json';


sub get_repo_pull_requests_cached {
    my ($repo ) = @_;

    my $file_path = sprintf $REPO_PR_DATA_FILE_PATH_TEMPLATE, $repo;

    my $content_ref = eval{ read_file(
        $file_path,
        { binmode => ':utf8', scalar_ref => 1 },
    )} // \'[]';
    warn $@ if $@;
    return $content_ref;
};

sub get_repos_pull_requests {
    my ($repos ) = @_;

    my $data = [];
    foreach my $repo (@$repos){
        my $repo_data = get_repo_pull_requests($repo);
        push @$data, @$repo_data;
    }
    return $data;
}


sub get_repo_pull_requests {
    my ($repo ) = @_;

    my $content_ref = get_repo_pull_requests_cached($repo);

    utf8::encode($$content_ref) if utf8::is_utf8($$content_ref);
    my $data = eval{ decode_json( $$content_ref ) } // [
    #    {
    #        "approved_by" : [
    #            "zurom"
    #        ],
    #        "assignee" : "madamada",
    #        "author" : "bessarabov",
    #        "codereview_state" : "pending",
    #        "changes_requested": 'blizzard, madamada',
    #        "disapproved_by" : [],
    #        "from_branch" : "PI-10330_edit_page_block_model",
    #        "id" : 1723,
    #        "issue" : {
    #            "key" : "PI-10330",
    #            "resolution" : null,
    #            "status" : "codeReview",
    #            "summary" : "МОЛ. Отправлять accessor блоков также как было сделано для площадок"
    #        },
    #        "mergeable" : 1,
    #        "tests_state" : "success",
    #        "timestamp_created_at" : 1507220603,
    #        "to_branch" : "master",
    #        "url" : "https://github.yandex-team.ru/partner/partner2/pull/1723"
    #    }
    ];
    warn $@ if $@;

    map { $_->{repo} = $repo } @$data;

    return $data;
}

sub update_repo_pull_requests_cache {
    my ($repo ) = @_;

    my $YS = get_startrek();

    my $pp = Partner::PR->new(
        github_owner => 'partner',
        github_repo  => $repo,
        github_token => $ENV{GITHUB_OAUTH_TOKEN},
    );

    my $data = $pp->get_open_pull_requests_from_github(approve_status => 1);

    foreach my $el (@{$data}) {
        ($el->{from_branch} // '') =~ /^(?:revert-\d+-)*(\w{2,}-\d+)/;

        my $issue_key = $1;

        if ($issue_key) {
            eval {
                my $issue = $YS->get_issue($issue_key);

                $el->{issue}->{key}        = $issue_key;
                $el->{issue}->{summary}    = $issue->{summary};
                $el->{issue}->{status}     = $issue->{status}->{key};
                $el->{issue}->{resolution} = $issue->{resolution}->{key};
            };
        }

        # На github.yandex-team.ru SStradomsky, а на стафе sstradomsky
        # https://center.yandex-team.ru/api/v1/user/SStradomsky/avatar/100.jpg - отдает 404, а если перевести в нижний регистр, то 200
        if (exists $el->{author}) {
            $el->{author} = lc($el->{author});
        }

        if (exists $el->{assignee}) {
            $el->{assignee} = lc($el->{assignee});
        }
    }

    write_file(
        sprintf($REPO_PR_DATA_FILE_PATH_TEMPLATE, $repo ),
        { binmode => ':utf8' },
        to_pretty_json($data),
    );

    return $data;
}


1;
