package Model::Wiki;

use utf8;
use strict;
use warnings;

use Text::CSV::Slurp;
use Yandex::Wiki;

sub get_curry2tickets{

    my $wiki = Yandex::Wiki->new(
        oauth_token => $ENV{YANDEX_WIKI_OAUTH_TOKEN},
    );

    my $content = $wiki->get_page('/partner/w/data-partner-curry-monitoring-startrek-tickets');

    $content =~ /%%\n(.*)%%/s;
    my $csv_table = $1;

    my $parsed_table = Text::CSV::Slurp->load(string => $csv_table);

    my $data = { map { $_->{problem} => $_->{ticket}} @{$parsed_table} };

    return $data;
}

1;