package Utils::Common;

use utf8;
use strict;
use warnings;

use base qw/ Exporter /;
our @EXPORT_OK = qw(
    get_tt
    get_startrek
    to_pretty_json
    get_all_people
    get_backend_people
    get_frontend_people
);

use JSON::PP;
use Template::AutoFilter;
use Yandex::StarTrek;

our $TT;
our $YS;

#  В будущем тут можно добавить is_on_vacation и какие-то другие данные
our @BACKEND_LOGINS = (
    { login => 'artrum',       },
    { login => 'blizzard',     },
    { login => 'daniil-belyak',},
    { login => 'dioksin',      },
    { login => 'ie2018',       },
    { login => 'ilia-aksenov', },
    { login => 'kadakin',      },
    { login => 'muriah',       },
    { login => 'niatzeni',     },
    { login => 'stasaleks',    },
    { login => 'zurom',        },
    { login => 'gookven',      },
    { login => 'leontevml',    },
    #--- стажеры
    { login => 'tsarkovvs', trainee => 1 },
    { login => 'vlstep2200', trainee => 1 },
    { login => 'yankuznetsov', trainee => 1 },
    #--- бывшие
    { login => 'alapaev',       ex => 1 },
    { login => 'asmirko',       ex => 1 },
    { login => 'bessarabov',    ex => 1 },
    { login => 'evmaksimenko',  ex => 1 },
    { login => 'i-gataullin',   ex => 1 },
    { login => 'madamada',      ex => 1 },
    { login => 'leonidlagunov', ex => 1 },
    { login => 'sovaowl', trainee => 1, ex => 1 },
    { login => 'sstradomsky',   ex => 1 },
    { login => 'suomi',         ex => 1 },
    { login => 'vasilchenkodd', ex => 1, trainee => 1 },
);

our @FRONTEND_LOGINS = (
    { login => 'chryse',             },
    { login => 'kristinasg',         },
    { login => 'nefri',              },
    { login => 'reshdarya',          },
    { login => 'sikalov',            },
    { login => 's-shirshov',         },
    { login => 'tessitore',          },
    #--- бывшие
    { login => 'alex-panin', ex => 1 },
    { login => 'mogafk',     ex => 1 },
    { login => 'ngraf',      ex => 1 },
    { login => 'olegzotov',  ex => 1 },
);

sub get_all_people {
    return _get_people( @BACKEND_LOGINS, @FRONTEND_LOGINS );
}

sub get_backend_people {
    return _get_people( @BACKEND_LOGINS );
}

sub get_frontend_people {
    return _get_people( @FRONTEND_LOGINS );
}

sub _get_people {
    my @people = @_;
    my $data = [
        sort {$a->{login} cmp $b->{login} } @people
    ];
    return $data;
}


sub get_tt {
    unless ($TT){
        $TT = Template::AutoFilter->new({
            ABSOLUTE => 1,
            ENCODING     => 'utf8',
        }) || die "$Template::ERROR\n";
    }
    return $TT;
}

sub get_startrek {
    unless ( $YS ){
        $YS = Yandex::StarTrek->new(
            oauth_token => $ENV{STARTREK_OAUTH_TOKEN},
        );
    }

    return $YS;
}

sub to_pretty_json {
    my ($data) = @_;

    my $json_coder = JSON::PP
        ->new
        ->pretty
        ->canonical
        ->indent_length(4);

    my $pretty_json = $json_coder->encode($data);

    return $pretty_json;
}


1;
