package Partner2::Juggler::API::Schema::Util;

use strict;
use warnings FATAL => 'all';
use utf8;

use Exporter;
use JSV::Validator;

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(
    time_start_property
    time_end_property
    day_start_property
    day_end_property
    literal_string
  );
our @EXPORT = @EXPORT_OK;

sub literal_string {
    return { type => 'string', enum => [$_[0]] };
}

sub time_schema {
    return { type => 'string', pattern => '\d{2}:\d{2}' };
}

sub time_start_schema {
    return time_schema();
}

sub time_start_property {
    return (time_start => time_start_schema());
}

sub time_end_schema {
    return time_schema();
}

sub time_end_property {
    return (time_end => time_end_schema());
}

sub day_schema {
    return { type => 'integer', minimum => 1, maximum => 7 };
}

sub day_start_schema {
    return day_schema();
}

sub day_start_property {
    return (day_start => day_start_schema());
}

sub day_end_schema {
    return day_schema();
}

sub day_end_property {
    return (day_end => day_end_schema());
}

1;
