#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Test::More tests => 3;
use Test::Differences qw(eq_or_diff);

use Partner2::Juggler::API;

use JSON;

{
    no warnings 'once';
    $Partner2::Juggler::API::CONFIG_PATH = './t/config.json';
}

my $FIXTURES = [
    {
        name   => 'without params',
        params => {},
        error  => 'Unknown notification type: undef'
    },
    {
        name   => 'match_raw_events wrong type',
        params => {
            "match_raw_events" => "wrong_value",
            "namespace" => "partner.test",
            "selector" => "service=qbit_validator.aggregator | service=money_growth.prod_aggregator",
            "template_name" => "phone_escalation",
            "template_kwargs" => {
                "logins" => [
                    '@svc_partnjorskijjinterfejjsjandeksa:backend_bugs_duty'
                ]
            },
        },
        error  => "/match_raw_events: instance type doesn't match schema type"
    },
    {
        name   => 'correct rule',
        params => {
            "match_raw_events" => JSON::false,
            "namespace" => "partner.test",
            "selector" => "service=qbit_validator.aggregator | service=money_growth.prod_aggregator",
            "template_name" => "phone_escalation",
            "template_kwargs" => {
                "day_end" => 7,
                "day_start" => 1,
                "restart_after" => 86400,
                "repeat" => 2,
                "delay" => 600,
                "logins" => [
                    '@svc_partnjorskijjinterfejjsjandeksa:backend_bugs_duty'
                ]
            },
            "check_kwargs" => {},
            "description" => "Тестирую эскалацию"
        },
    },
];

main();

sub main {
    my $pja = Partner2::Juggler::API->new(
        juggler_token => 'juggler-token',
        host          => 'test.host',
        namespace     => 'test.namespace'
    );

    foreach my $test (@$FIXTURES) {
        my $result;

        eval {$result = $pja->_check_add_or_update_notify_rule_options(%{$test->{'params'}})};

        my $expected_error = delete($test->{'error'});

        if ($@ || $expected_error) {
            my $got_error = $@;
            $expected_error //= 'ERROR';
            like($got_error, qr/\Q$expected_error\E/, '_check_add_or_update_notify_rule_options ' . $test->{'name'});
            $got_error =~ s{ at t/lib.*\n$}{};

            next;
        }

        ok($result, '_check_add_or_update_notify_rule_options ' . $test->{'name'});
    }
}
