#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Test::More tests => 94;
use Test::Exception;
use File::Slurp qw(write_file read_file);
use JSON qw(to_json from_json);

use Partner2::Juggler::API;

{
    no warnings 'once';
    $Partner2::Juggler::API::CONFIG_PATH = './t/config.json';
}

my $data_path = './t/lib/Partner2/Juggler/API/_check_add_or_update_options.json';

main();

sub main {
    my $pja = Partner2::Juggler::API->new(
        juggler_token => 'juggler-token',
        host          => 'test.host',
        namespace     => 'test.namespace'
    );

    my $FIXTURES = from_json(read_file($data_path));

    foreach my $test (@$FIXTURES) {
        my $result;

        eval {$result = $pja->_check_add_or_update_options(%{$test->{'params'}})};

        my $expected_error = delete($test->{'error'});

        if ($@ || $expected_error) {
            my $got_error = $@;
            $expected_error //= 'ERROR';
            like($got_error, qr/\Q$expected_error\E/, '_check_add_or_update_options ' . $test->{'name'});
            $got_error =~ s{ at t/lib.*\n$}{};
            if ($got_error) {
                $test->{'error'} = $got_error;
            }

            next;
        }

        ok($result, '_check_add_or_update_options ' . $test->{'name'});
    }

    if ($ENV{SELF_UPDATE}) {
        write_file($data_path, to_json($FIXTURES, {utf8 => 1, pretty => 1, canonical => 1}));
    }
}
