#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Test::More tests => 8;
use Test::Exception;

use Partner2::Juggler::API;

{
    no warnings 'once';
    $Partner2::Juggler::API::CONFIG_PATH = './t/config.json';
}

my $pja = Partner2::Juggler::API->new(
    juggler_token => 'juggler-token',
    host          => 'test.host',
    namespace     => 'test.namespace'
);

ok($pja->_check_options([], {}), 'Empty options and hash');

ok($pja->_check_options(['key'], {}), 'Empty hash');

ok($pja->_check_options(['key'], {key => 1}), 'Options and hash keys equals');

ok($pja->_check_options(['key', 'key2'], {key => 1}), 'Options more than hash keys');

throws_ok {$pja->_check_options(['key'], {key => 1, key2 => 2})} qr/Unknown options: key2/, 'Extra key2';

throws_ok {$pja->_check_options(['key'], {key => 1, key2 => 2}, '/path/')} qr/Unknown options: \/path\/key2/,
  'Extra key2 with prefix';

throws_ok {$pja->_check_options([], {key => 1})} qr/Unknown options: key/, 'empty options';

throws_ok {$pja->_check_options([], {key => 1}, '/path/')} qr/Unknown options: \/path\/key/,
  'empty options with prefix';
