#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Test::More tests => 6;

use Partner2::Juggler::API;

my $FIXTURES = [
    {
        name   => 'without params',
        params => [],
        error  => 'Option "ttl" is required',
    },
    {
        name   => '5',
        params => [5],
        result => 5,
    },
    {
        name   => '5s',
        params => ['5s'],
        result => 5,
    },
    {
        name   => '5m',
        params => ['5m'],
        result => 300,
    },
    {
        name   => '5h',
        params => ['5h'],
        result => 18000,
    },
    {
        name   => '5a',
        params => ['5a'],
        error  => 'Expected format like "5s"',
    },
];

foreach my $test (@$FIXTURES) {
    my $result;

    eval {$result = Partner2::Juggler::API::_ttl_to_seconds(@{$test->{'params'}})};

    if ($@ || $test->{'error'}) {
        $test->{'error'} //= 'ERROR';
        like($@, qr/\Q$test->{'error'}\E/, '_ttl_to_seconds - ' . $test->{'name'});

        next;
    }

    is($result, $test->{'result'}, '_ttl_to_seconds - ' . $test->{'name'});
}
