#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Scalar::Util qw(blessed);

use Test::More tests => 3;
use Test::Exception;
use Test::Differences qw(eq_or_diff);

use Partner2::Juggler::API;

{
    no warnings 'once';
    $Partner2::Juggler::API::CONFIG_PATH = './t/config.json';
}

my $pja = Partner2::Juggler::API->new(
    juggler_token => 'juggler-token',
    host          => 'test.host',
    namespace     => 'test.namespace'
);

throws_ok {$pja->decode_from_json()} qr/Expected json/, 'json is required';

throws_ok {$pja->decode_from_json('{')} qr/Error: '"' expected, at character offset 1/, 'Error';

eq_or_diff($pja->decode_from_json('{"test":true}'), {'test' => JSON::XS::true}, 'Decode');
