#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Scalar::Util qw(blessed);

use Test::More tests => 2;

use Partner2::Juggler::API;

{
    no warnings 'once';
    $Partner2::Juggler::API::CONFIG_PATH = './t/config.json';
}

my $pja = Partner2::Juggler::API->new(
    juggler_token => 'juggler-token',
    host          => 'test.host',
    namespace     => 'test.namespace'
);

is($pja->encode_to_json(), "null\n", 'Encode undef');

is(
    $pja->encode_to_json({"test" => JSON::XS::true}), '{
   "test" : true
}
', 'Encode'
);
