#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Scalar::Util qw(blessed);

use Test::More tests => 4;
use Test::Exception;
use Test::Differences qw(eq_or_diff);

use Partner2::Juggler::API;

{
    no warnings 'once';
    $Partner2::Juggler::API::CONFIG_PATH = './t/config.json';
}

my $pja = Partner2::Juggler::API->new(
    juggler_token => 'juggler-token',
    host          => 'test.host',
    namespace     => 'test.namespace'
);

throws_ok {$pja->get_option()} qr/Expected name/, 'name is required';

eq_or_diff($pja->get_option('logins'), ['test-login', 'test-login-2'], 'Get logins');

is($pja->get_option('not_exists', 'default'), 'default', 'Get not exists option with default');

throws_ok {$pja->get_option('not_exists')} qr!Can not find option "not_exists" in config: ./t/config.json!,
  'Get not exists option without default';
