#!/usr/bin/perl

use strict;
use warnings FATAL => 'all';
use utf8;

use Scalar::Util qw(blessed);

use Test::More tests => 6;
use Test::Exception;
use Test::Differences qw(eq_or_diff);

require_ok('Partner2::Juggler::API');

{
    no warnings 'once';
    $Partner2::Juggler::API::CONFIG_PATH = './t/config.json';
}

throws_ok {Partner2::Juggler::API->new()} qr/Expected option "juggler_token"/, 'juggler_token is required';

my $pja = Partner2::Juggler::API->new(
    juggler_token => 'juggler-token',
    host          => 'test.host',
    namespace     => 'test.namespace'
);

is(blessed($pja), 'Partner2::Juggler::API', 'Object created');

is(blessed($pja->{'__JSON__'}), 'JSON::XS', '__JSON__');

is(blessed($pja->{'__LWP__'}), 'LWP::UserAgent', '__LWP__');

eq_or_diff(
    $pja->{'__CONFIG__'},
    {
        'checks_url'     => 'http://juggler-api.search.yandex.net/api/',
        'juggler_token'  => 'juggler-token',
        'md5_hex_config' => '5ad9dc843d220d92a5eb27d511837526',
        'namespace'      => 'test.namespace',
        'logins'         => ['test-login', 'test-login-2'],
        'host'           => 'test.host',
        'push_url'       => 'http://juggler-push.search.yandex.net/'
    },
    '__CONFIG__',
    {context => 1}
);
