#!/bin/bash

# USAGE:
# DEBUG=2  run_check.sh Check::{NAME}

PACKAGE=$1

# FOOBarBazFOO-> foo-bar-baz-foo
LOG_FILE=$(
  echo $PACKAGE  \
    | perl -ne 's/Check:://; s/:://g; print $_' \
    | perl -ne 's/([A-Z])([A-Z]+)([A-Z])/$1\L$2\U$3/g; s/([A-Z])$/\L\1/; s/([A-Z])/-\L$1/g; s/^-//;  print $_'
);

LOG_FILE_PATH="/var/log/partner2-juggler-checks-dev/${LOG_FILE}.log"

if [[ $DEBUG -gt "2" ]]; then
   LOG_FILE_PATH='/dev/stdout'
   set -x
fi

cd /app;
/usr/local/bin/carton exec \
  perl -I/app/lib  -M$PACKAGE \
    -e  "${PACKAGE}->new->send_events()"  2>&1 \
     | ts "%Y-%m-%d %H:%M:%S  $$ " \
  &>> $LOG_FILE_PATH
