package Check::Adfox;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;
use JSON::PP;

use lib::abs qw(
  ../../lib
  );

use Util;

sub get_juggler_checks {
    my ($self) = @_;

    my $check = {
        service => 'mobile_mediation.rtd',
        host    => 'rtd.yd.adfox.net',
        ttl     => '65m',
        tags    => [$self->get_notification_tags()],
    };

    $self->add_wiki_meta_url($check,
        'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/adfox/');

    return [$check];
}

sub check {
    my ($self, $check, $pja) = @_;

    my $response = get_response(sprintf('http://%s/ping', $check->{'host'}));

    my $success = $response->is_success;
    send_event($pja, $check, $success);
}

1;
