package Check::Balancer;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_PROD $ENV_PREPROD);
use Util;

my %HOSTS = (
    $ENV_PROD => [
        qw (
            partner.yandex.ru
            partner2.yandex.ru
        )
    ],
    $ENV_PREPROD => [
        qw (
            partner2-preprod.yandex.ru
        )
    ],

  );

sub get_juggler_checks {
    my ($self) = @_;

    my @checks = ();
    foreach my $stage (sort keys %HOSTS) {
        foreach my $host (sort @{$HOSTS{$stage}}) {
            my $safe_host = $host;
            $safe_host =~ tr/-\./_/;

            my $check = {
                service => "balancer.$safe_host",
                host    => $host,
                ttl     => '600s',
                tags    => [ $self->get_notification_tags(), $stage],
                active  => 'icmpping',
            };

            $self->add_wiki_meta_url($check,
                'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/balancer/');

            push(
                @checks,
                $check
            );
        }
    }

    return \@checks;
}

1;
