package Check::Balancer5xx;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use lib::abs qw(../../lib);
use base qw(Check);

use Carp;
use Constants qw ($ENV_PROD);

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my $check = {
        aggregator        => 'logic_or',
        aggregator_kwargs => {nodata_mode => 'force_ok',},
        children          => [
            {
                host => 'host=total & service=balancer_5xx.push-api-balancer-production',
                service => "all",
                type => 'EVENTS',
                instance => "all",
            }
        ],
        tags => [$self->get_fast_notification_tags(), $self->get_warden_alert_create_tag()],
        refresh_time => 60,
        service      => "balancer_outgoing_5xx.$ENV_PROD",
        pronounce    => "Балансер отдает пятисотки",
        ttl          => '120s',
    };

    $self->add_wiki_meta_url($check,
        'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/balancer5xx/');

    return [$check];
}

1;
