package Check::CreatorDockerDBImage;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Moment;
use Carp;
use JSON::PP;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_DEV);
use Util;

my $SERVICE = 'docker_db_image_update_date';

sub get_juggler_checks {
    my ($self) = @_;

    my $creator_hosts = get_json_content('https://partner.yandex-team.ru/api/0/creator_hosts.json');

    my @checks = ();

    foreach (@$creator_hosts) {
        my $check = {service => $SERVICE, host => $_, ttl => '65m', tags => [$ENV_DEV],};

        $self->add_wiki_meta_url($check,
            'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/docker-db-image-update-date/');

        push(@checks, $check);
    }

    return \@checks;
}

sub check {
    my ($self, $check, $pja) = @_;

    my $docker_db_images = get_json_content(sprintf('https://%s/api/3/cached_docker_db_images', $check->{'host'}));
    $docker_db_images = [] if ref($docker_db_images) eq 'HASH';

    my $latest_docker_db_image = $docker_db_images->[-1] // '2000-01-01';
    my ($docker_db_image_date) = $latest_docker_db_image =~ m/([\d-]{10})\z/a;

    my $days =
      (Moment->now()->get_timestamp() - Moment->new(dt => $docker_db_image_date . ' 00:00:00')->get_timestamp()) /
      86_400;

    my $success = $days < 4;
    send_event($pja, $check, $success);
}

1;
