package Check::CreatorNoOccupied;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use feature 'say';
use Carp;
use JSON::PP;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_DEV);
use Util;

sub get_juggler_checks {
    my ($self) = @_;

    my $creator_hosts = get_json_content('https://partner.yandex-team.ru/api/0/creator_hosts.json');

    my @checks = ();
    foreach my $host (sort @$creator_hosts) {
        my ($name) = $host =~ /^.*?\-(.*?)\./;

        my $check = {
            service => sprintf('creator.%s.no_occupied', $name),
            host    => $host,
            ttl     => '65m',
            tags    => [$ENV_DEV],
        };

        $self->add_wiki_meta_url($check,
            'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/creator-no-occupied/');

        push(@checks, $check);
    }

    return \@checks;
}

sub check {
    my ($self, $check, $pja) = @_;

    my $betas = get_json_content(sprintf('https://%s/api/3/betas', $check->{'host'}));

    my $has_occupied;
    foreach my $beta (sort { $a->{'port'} <=> $b->{'port'} }@{$betas}) {
        if ($beta->{'status'} eq 'occupied') {
            $has_occupied = 1;
            say sprintf(
                'Server "%s" port "%s" status "%s"',
                $check->{'host'}, colored($beta->{'port'}, 'red'),
                $beta->{'status'}
            );
        }
    }

    send_event($pja, $check, !$has_occupied);
}

1;
