package Check::DeployDiskSpace;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_PROD $ENV_PREPROD $ENV_TEST);
use Util;

my %HOSTS = (
    $ENV_PREPROD => {
        name    => 'partner-preprod-stage',
        unit    => [qw(Crons Backend)],
        cluster => [qw(vla)],
    },
    $ENV_PROD => {
        name    => 'partner-production-stage',
        unit    => [qw(Crons Backend)],
        cluster => [qw(myt sas vla)],
    },
    $ENV_TEST => {
        name    => 'partner-test-stage',
        unit    => [qw(Crons Backend)],
        cluster => [qw(sas vla)],
    },
);

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my @checks;

    foreach my $metric (sort qw(disk_space inode)) {
        my $wiki_page = $metric;
        $wiki_page =~ tr/_/-/;

        foreach my $stage (sort keys %HOSTS) {
            foreach my $unit (sort @{$HOSTS{$stage}{unit}}) {
                my $check = {
                    aggregator   => 'logic_or',
                    children     => [
                        map {
                            {
                                host    => sprintf('%s.%s@cluster=%s', $HOSTS{$stage}{name}, $unit, $_),
                                    service => "$metric.$stage",
                                    type    => 'YP_PODSET',
                            }
                        } sort @{$HOSTS{$stage}{cluster}}
                    ],
                    tags         => [
                        (
                            $stage eq $ENV_PROD || $stage eq $ENV_PREPROD
                                ? ($self->get_notification_tags(),)
                                : ()
                        ),
                        $stage
                    ],
                    refresh_time => 300,
                    host         => $self->get_host_by_stage($stage),
                    service      => sprintf('partner2_deploy.%s_%s_%s_aggregator', $stage, $unit, $metric),
                    pronounce    => "На дисках $stage осталось менее 15 процентов места или инод",
                    ttl          => '900s',
                };

                $self->add_wiki_meta_url($check, "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/$wiki_page/");

                push(@checks, $check);
            }
        }
    }

    return \@checks;
}

1;
