package Check::DeployReadnessProbe;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;
use HTTP::Tiny;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_PROD $ENV_PROD_STAGE_FROM_PI_APPLICATION_JSON $ENV_PREPROD $ENV_TEST);
use Util;

my %HOSTS = (
    $ENV_PREPROD => {
        name     => 'partner-preprod-stage',
        unit     => [ qw(Backend) ],
        host     => "partner-preprod",
        clusters => [qw(iva vla)],
    },
    $ENV_PROD => {
        name    => 'partner-production-stage',
        unit    => [qw(Backend)],
        host    => "partner-prod",
        clusters => [qw(myt sas vla)],
        # raw events are sent with stage from Application.json,for prod its 'production', not 'prod' (=$ENV_PROD)
        stage    => $ENV_PROD_STAGE_FROM_PI_APPLICATION_JSON,
    },
    $ENV_TEST => {
        name    => 'partner-test-stage',
        unit    => [qw(Backend)],
        host    => "partner-test",
        clusters => [qw(sas vla)],
    },
);

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my @checks;

    for my $stage (sort keys %HOSTS) {
        my @children;
        for my $unit (sort @{$HOSTS{$stage}{unit}}) {
            for my $cluster (@{$HOSTS{$stage}{clusters}}) {
                for my $workload (sort qw(api_fcgi intapi_fcgi interface_fcgi rest_api)) {
                    push @children, {
                        host    => sprintf('%s.%s@cluster=%s', $HOSTS{$stage}{name}, $unit, $cluster),
                        service => sprintf("readness_probe.%s.%s.%s", 'PerlApp', $workload, $HOSTS{$stage}{stage} // $stage),
                        type    => 'YP_PODSET',
                    };
                }
            }
        }

        my $check = {
            aggregator   => 'logic_or',
            children     => \@children,
            tags         => [
                $self->get_notification_tags(),
                $stage
            ],
            refresh_time => 300,
            host         => $self->get_host_by_stage($stage),
            service      => sprintf('readness_probe.%s_aggregator', $stage),
            pronounce    => "Провалилась проба готовности",
            ttl          => '900s',
        };
        $self->add_wiki_meta_url($check, "https://wiki.yandex-team.ru/partner/w/dev/infrastructure/systems/common-services/deploy/selfcheck/");
        push(@checks, $check);
    }
    return \@checks;
}

1;
