package Check::DeploySpecsCheck;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use lib::abs qw(../../lib);
use base qw(Check);

use Moment;
use Carp;
use Constants qw ($ENV_PROD);
use Util;


my @hosts = (
    'partner-prod',
    'partner-preprod',
    'partner-test',
);

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self, $checks) = @_;

    my $check = {
        aggregator        => 'logic_or',
        children => [ map { {'host' => $_, 'service' => 'partner_check_deploy_specs'} } @hosts ],
        tags => [$self->get_dashboard_tag()],
        service      => "partner_check_deploy_specs",
        pronounce    => "Конфиги в деплое и коде имеют отличия, нужно обновить",
        ttl          => '25h',
    };

    $self->add_wiki_meta_url($check,
        'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/check-deploy-specs/');

    return [$check];
}

1;
