package Check::DevBetaBuild;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use Constants qw ($ENV_DEV);

use lib::abs qw(
  ../../lib
  );

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    # Raw events: https://juggler.yandex-team.ru/raw_events/?query=service%3Dcheck-dev-partner-beta
    # from this script: https://github.yandex-team.ru/partner/partner_ansible/blob/master/roles/check-dev-partner-beta/files/check-dev-partner-beta.sh

    my $check = {
        aggregator => 'logic_and',
        host       => $self->get_host_by_stage($ENV_DEV),
        service    => 'check-dev-partner-beta',
        children   => [
            map {{service => 'check-dev-partner-beta', host => $_, type => 'YP_PODSET',}}
                qw(dev-partner6@cluster=vla dev-partner4@cluster=sas dev-main1@cluster=sas)
        ],
        tags         => [$self->get_dashboard_tag(), $ENV_DEV,],
        refresh_time => 300,
        ttl          => '608400s',
        pronounce =>
            "Еженедельная сборка дев-беты завершилась неудачно",
    };

    $self->add_wiki_meta_url($check, "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/check-dev-partner-beta/");

    return [$check];
}

1;
