package Check::FormatSystem;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;
use JSON::PP;

use lib::abs qw(
  ../../lib
  );

use Util;
use Constants qw ($ENV_PROD $ENV_TEST);

sub get_juggler_checks {
    my ($self) = @_;

    my $checks = [
        {
            service => 'format.system',
            host    => 'pcode-msf-prod.yandex-team.ru',
            ttl     => '15m',
            tags    => [$self->get_notification_tags(), $ENV_PROD],
        },
        {service => 'format.system', host => 'pcode-msf-test.yandex-team.ru', ttl => '15m', tags => [$ENV_TEST]},
    ];

    map {
        $self->add_wiki_meta_url($_, "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/format-system/")
    } @$checks;

    return $checks;
}

sub check {
    my ($self, $check, $pja) = @_;

    # TODO: call alive endpoint when it's ready
    my $data = get_json_content(sprintf('https://%s/api/schemas/pcode-7012/formats/adaptive0418', $check->{'host'}),
        5, 3, 1, {ssl_opts => {SSL_ca_file => '/etc/ssl/certs/YandexInternalRootCA.pem'}});

    my $success = eval {$data->{'name'} eq 'adaptive0418'};
    send_event($pja, $check, $success);
}

1;
