package Check::HTTP;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_PROD $ENV_PREPROD $ENV_TEST $DEFAULT_HOST);
use Util;

my %SERVICES = (
    $ENV_PROD => [
        qw(
          partner2_deploy.http_check_aggregator
          )
    ],
    $ENV_PREPROD => [
        qw(
          partner2_deploy.http_check_aggregator
          )
    ],
    $ENV_TEST => [
        qw(
          partner2_deploy.http_check_aggregator
          )
    ],
);

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my @checks;

    foreach my $stage (sort keys %SERVICES) {
        my $check = {
            aggregator => 'logic_or',
            children   => [
                map {{host => $self->get_host_by_stage($stage), service => $_,}}
                    sort @{$SERVICES{$stage}}
            ],
            refresh_time => 300,
            service      => 'partner2_http_check.aggregator',
            host         => $self->get_host_by_stage($stage),
            ttl          => '900s',
            tags         => [
                (
                    $stage eq $ENV_PROD || $stage eq $ENV_PREPROD || $stage eq $ENV_TEST
                        ? ($self->get_notification_tags(),)
                        : ()
                ),
                (
                    $stage eq $ENV_PROD ? ($self->get_warden_alert_create_tag()) : ()
                ),
                $stage,
            ],
        };

        $self->add_wiki_meta_url($check, "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/http-https/");

        push(@checks, $check);
    }

    return \@checks;
}

1;
