package Check::JSONAPI;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
    ../../lib
);

use Constants qw($ENV_PROD %ENV_TAGS @MAIN_STAGES);
use Util;

my $SERVICE_NAME = 'logs_monitoring__check_status__jsonapi';

sub get_juggler_checks {
    my ($self) = @_;

    my @checks;

    my $deploy_stages = $self->get_deploy_stages(stages => \@MAIN_STAGES, units => [ 'Backend' ]);

    foreach my $stage (sort @MAIN_STAGES) {
        my $deploy_stage = $deploy_stages->{$stage};

        foreach my $dc (sort @{$deploy_stage->{'units'}{'Backend'}{'dcs'}}) {
            push @checks, {
                aggregator   => 'logic_or',
                children     => [
                    {
                        service => $SERVICE_NAME,
                        type    => 'YP_PODSET',
                        host    => sprintf('%s.Backend@cluster=%s', $stage, $dc),,
                    }
                ],
                tags         => [
                    $deploy_stage->{'env'},
                    $self->get_geo_tag_by_dc($dc),
                ],
                options      => {
                    stage => $deploy_stage->{'env'},
                },
                refresh_time => 300,
                service      => 'partner2_jsonapi',
                host         => $self->get_host_by_deploy_stage($deploy_stage, dc => $dc),
                ttl          => '900s',
            };
        }
    }

    return \@checks;
}

sub get_juggler_aggregator_checks {
    my ($self, $checks) = @_;

    my @checks;

    foreach my $stage (sort keys %ENV_TAGS) {
        my @children = map {
            {
                host    => $_->{host},
                service => $_->{service},
            }
        } grep {$_->{options}->{stage} eq $stage} @$checks;

        unless(@children) {
            next;
        }

        my $check = {
            aggregator   => 'logic_or',
            children     => \@children,
            tags         => [
                (
                    $stage eq $ENV_PROD
                        ? ($self->get_notification_tags(),)
                        : ()
                ),
                $stage,
            ],
            refresh_time => 300,
            pronounce    => 'Функциональность JSON API',
            service      => 'partner2_jsonapi.aggregator',
            host         => $self->get_host_by_stage($stage),
            ttl          => '900s',
        };

        $self->add_wiki_meta_url($check, "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/partner2-jsonapi/");

        push(@checks, $check);
    }

    return \@checks;
}

1;
