package Check::MOL;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;
use JSON::PP;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_PROD $ENV_PREPROD);
use Util;

sub get_juggler_checks {
    my ($self) = @_;

    my $checks = [
        {service => 'mol', host => 'bsfastexport-pre.yandex.ru', ttl => '65m', tags => [$ENV_PREPROD],},
        {
            service => 'mol',
            host    => 'bsfastexport.yandex.ru',
            ttl     => '65m',
            tags    => [$self->get_notification_tags, $ENV_PROD],
        },
    ];

    map {
        $self->add_wiki_meta_url($_, "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/mol/")
    } @$checks;

    return $checks;
}

sub check {
    my ($self, $check, $pja) = @_;

    my $query = encode_json(
        {
            currency         => 'RUB',
            date_from        => '20160701',
            date_to          => '20160701',
            countable_fields => ['Shows'],
        }
    );

    my $data = get_json_content(
        sprintf('http://%s:80/export/master-report-pi.cgi', $check->{'host'}),
        30, 1, 3,
        {
            method  => 'POST',
            headers => {'Content-Type' => 'application/json'},
            content => $query,
        },
    );

    my $success = eval {$data->{'status'} == 0};
    send_event($pja, $check, $success);
}

1;
