package Check::Moneymap;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_PROD $ENV_PREPROD);
use Util;

my $SERVICE = 'moneymap';
my $URL     = 'https://%s/api/v1/pages?page_id[eq]=1';
my $HOSTS   = {
    $ENV_PROD    => {
        host       => 'moneymap.in.yandex-team.ru',
        tvm_app_id => 2010230
    },
    $ENV_PREPROD => {
        host       => 'preprod.moneymap.in.yandex-team.ru',
        tvm_app_id => 2010232,
    },
};

sub get_juggler_checks {
    my ($self) = @_;

    my @checks;
    foreach my $stage (sort keys %$HOSTS) {
        my $check = {
            service => $SERVICE,
            host    => $HOSTS->{$stage}->{host},
            ttl     => '35m',
            tags    => [$stage],
        };

        $self->add_wiki_meta_url($check, "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/moneymap/");

        push(@checks, $check);
    }

    return \@checks;
}

sub check {
    my ($self, $check, $pja) = @_;

    my @checks = ();
    foreach my $stage (sort keys %$HOSTS) {
        my ($host, $tvm_app_id) = @{$HOSTS->{$stage}}{qw( host tvm_app_id )};

        my $url = sprintf($URL, $host);
        my $json_data = get_json_content(
            $url, 5, 3, 1,
            {headers => {'Content-Type' => 'application/json'}},
            {
                tvm_dst_alias => 'moneymap',
                tvm_src       => $tvm_app_id
            }
        );

        my $success = eval {$json_data->{'pages'}[0]->{'page_id'} == 1};
        send_event($pja, $check, $success);
    }

    return \@checks;
}
