package Check::MysqlSyncData;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
    ../../lib
);

use Constants qw($ENV_TEST);
use Util;

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my $check = {
        aggregator   => 'logic_and',
        children     => [
            {
                service => 'mysql-sync-data',
                host    => 'dev-main1@cluster=sas',
                type    => 'YP_PODSET',
            },
            {
                service => 'mysql-sync-data',
                host    => 'dev-partner4@cluster=sas',
                type    => 'YP_PODSET',
            },
            {
                service => 'mysql-sync-data',
                host    => 'dev-partner6@cluster=vla',
                type    => 'YP_PODSET',
            }
        ],
        tags         => [
            $self->get_shorttime_notification_tags(),
            $ENV_TEST,
        ],
        refresh_time => 300,
        host         => $self->get_host_by_stage($ENV_TEST),
        service      => 'mysql-sync-data',
        ttl          => '90000s', # 25 часов
    };

    $self->add_wiki_meta_url($check, 'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/mysql-sync-data/');

    return [ $check ];
}

1;
