package Check::NewCreator;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Moment;
use Carp;
use JSON::PP;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_DEV);
use Util;

my $API_VERSION = 3;

sub get_juggler_checks {
    my ($self) = @_;

    my $hosts = get_json_content('https://partner.yandex-team.ru/api/0/creator_hosts.json');
    $hosts = [] if ref($hosts) eq 'HASH';

    my @checks = ();
    foreach my $host (sort @$hosts) {
        my ($name) = $host =~ /^.*?\-(.*?)\./;

        my $check = {
            service => sprintf('creator.%s.api.%s', $name, $API_VERSION),
            host    => $host,
            ttl     => '65m',
            tags    => [$ENV_DEV],
        };

        $self->add_wiki_meta_url($check, 'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/creator-api/');

        push(@checks, $check);
    }

    return \@checks;
}

sub check {
    my ($self, $check, $pja) = @_;

    my $data = get_json_content(sprintf('https://%s/api/%s/alive', $check->{'host'}, $API_VERSION));

    my $success = eval {$data->{'status'} eq 'ok'};
    send_event($pja, $check, $success);
}

1;
