package Check::OnlyOneFrontAlive;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
  ../../lib
  );

use Util;
use Constants qw($DEPLOY_HOSTS $ENV_PROD);

my @SERVICES = (
    'http_check.v2_alive',
);


sub get_juggler_checks {[]}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my @children;
    my $unit = 'partner-production-stage.Backend';
    foreach my $dc (sort @{$DEPLOY_HOSTS->{$ENV_PROD}->{$unit}->{dc}}) {
        my $host = "$unit\@cluster=$dc";
        my $safe_host = get_safe_host($host);
        for my $service (sort @SERVICES) {
            push @children, {
                host    => $safe_host,
                service => $service,
            }
        }
    }

    my $check = {
        service    => 'partner2_frontend.alive_check_aggregator',
        ttl        => '180s',
        tags       => [ $self->get_fulltime_notification_tags(), $self->get_warden_alert_create_tag() ],
        aggregator => 'more_than_limit_is_crit',
        aggregator_kwargs => {
            limit => @children - 1,
        },
        children   => \@children,
        pronounce => "Остался только один фронт",
    };

    $self->add_wiki_meta_url($check, 'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/partner2-frontend-alive-check/');

    return [$check];
}

1;
