package Check::Ping;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
  ../../lib
  );

use Util;

use Constants qw (
    $ENV_DEV
    $ENV_PREPROD
    $ENV_PROD
    $ENV_TEST
);

my %SERVICES = (
    $ENV_PROD => [
        qw(
          partner2_deploy.ping_aggregator
          )
    ],
    $ENV_PREPROD => [
        qw(
          partner2_deploy.ping_aggregator
          )
    ],
    $ENV_TEST => [
        qw(
          partner2_deploy.ping_aggregator
          )
    ],
    $ENV_DEV  => [
        qw(
            partner2_qyp.ping_aggregator
        )
    ],
);

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my @checks;

    foreach my $stage (sort keys %SERVICES) {
        my $host = $self->get_host_by_stage($stage);

        my $check = {
            aggregator => 'logic_or',
            children   => [
                map {{host => $host, service => $_,}}
                    sort @{$SERVICES{$stage}}
            ],
            refresh_time => 90,
            service      => 'partner2_ping.aggregator',
            host         => $host,
            ttl          => '300s',
            tags         => [
                (
                    $stage eq $ENV_PROD || $stage eq $ENV_PREPROD || $stage eq $ENV_TEST
                        ? ($self->get_notification_tags(),)
                        : ()
                ),
                $stage,
            ],
        };

        $self->add_wiki_meta_url($check, 'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/ping/');

        push(@checks, $check);
    }

    return \@checks;
}

1;
