package Check::QYPPing;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_PROD $ENV_DEV);
use Util;

my $HOSTS = {
    $ENV_DEV  => {
       'dev-partner4' => [
            qw(sas)
        ],
        'dev-partner6'  => [
            qw(vla)
        ],
        'dev-main1' => [
            qw(sas)
        ]
    },
};

sub get_juggler_checks {
    my ($self) = @_;

    my @checks;

    foreach my $stage (sort keys %{$HOSTS}) {
        foreach my $unit (sort keys %{$HOSTS->{$stage}}) {
            foreach my $dc (sort @{$HOSTS->{$stage}->{$unit}}) {
                my $host = "$unit\@cluster=$dc";
                my $safe_host = get_safe_host($host);
                push @checks,
                    {
                        active     => 'icmpping',
                        aggregator => 'logic_or',
                        children   => [
                            {
                                host => $host,
                                service => 'ping',
                                type => 'YP_PODSET',
                            }
                        ],
                        tags => [
                            $stage,
                            $self->get_geo_tag_by_dc($dc),
                        ],
                        options => {
                            stage => $stage,
                        },
                        refresh_time => 90,
                        service      => 'partner2_qyp.ping',
                        host         => $safe_host,
                        ttl          => '300s',
                    };
            }
        }
    }
    return \@checks;
}

sub get_juggler_aggregator_checks {
    my ($self, $checks) = @_;

    my @checks;

    foreach my $stage (sort keys %{$HOSTS}) {
        my @children = map {
            {
                host    => $_->{host},
                service => $_->{service},
            }
        } grep {$_->{options}->{stage} eq $stage} @$checks;

        my $check = {
            aggregator   => 'logic_or',
            children     => \@children,
            tags         => [
                (
                    $stage eq 'prod'
                        ? ($self->get_notification_tags(),)
                        : ()
                ),
                $stage,
            ],
            refresh_time => 90,
            service      => 'partner2_qyp.ping_aggregator',
            host         => $self->get_host_by_stage($stage),
            ttl          => '300s',
        };

        $self->add_wiki_meta_url($check, "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/ping/");

        push(@checks, $check);
    }

    return \@checks;
}

1;
