package Check::Statistics5xx;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use lib::abs qw(../../lib);
use base qw(Check);

use Carp;
use Constants qw ($ENV_PROD);    #

my %HOSTS = (
    $ENV_PROD => {
        name    => 'partner-production-stage',
        unit    => [qw(Backend)],
        cluster => [qw(myt sas vla)],
    },
    # $ENV_PREPROD => {
    #     name    => 'partner-preprod-stage',
    #     unit    => [qw(Backend)],
    #     cluster => [qw(iva vla)],
    # },
);

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my @checks;

    foreach my $metric (sort qw( statistics_5xx  mol_5xx )) {
        foreach my $stage (sort keys %HOSTS) {
            foreach my $unit (sort @{$HOSTS{$stage}{unit}}) {
                my $check = {
                    aggregator        => 'logic_and',
                    aggregator_kwargs => {nodata_mode => 'force_ok',},
                    children          => [
                        map {
                            {
                                host    => sprintf('%s.%s@cluster=%s', $HOSTS{$stage}{name}, $unit, $_),
                                service => "$metric.$stage",
                                type    => 'YP_PODSET',
                            }
                          } sort @{$HOSTS{$stage}{cluster}}
                    ],
                    tags => [
                        ($stage eq 'prod' ? ($self->get_notification_tags(),) : ()),
                    ],
                    refresh_time => 300,
                    service      => sprintf('%s.%s', $metric, $stage),
                    pronounce    => "В статистике появились пятисотки",
                    ttl          => '300s',
                };

                $self->add_wiki_meta_url($check,
                    'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/statistics5xx/');

                push @checks, $check;
            }
        }
    }

    return \@checks;
}

1;
