package Check::TestBSSOAP;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;
use JSON::PP;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_TEST);
use Util;

my $SERVICE = 'bs.bssoap_pi_integration';
my $HOST    = 'bssoap-1.bssoap.pi-integration-qloud.bssoap.yabs-qabs-osc.stable.qloud-d.yandex.net';

sub get_juggler_checks {
    my ($self) = @_;

    my $check = {
        service => $SERVICE,
        host    => $HOST,
        ttl     => '35m',
        tags    => [$ENV_TEST],
    };

    $self->add_wiki_meta_url($check,
        'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/bssoap-pi-integration/');

    return [$check];
}

sub check {
    my ($self, $check, $pja) = @_;

    my $data = get_json_content(sprintf('http://%s/export/dsp-api.cgi?func=get_dsp&dsp_id=5', $check->{'host'}),
        10, 3, 1, {utf_encode => 1});

    my $success = eval {$data->{'data'}[0]{'DSPID'} eq '5'};
    send_event($pja, $check, $success);
}

1;
