package Check::TestBalance;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;
use XMLRPC::Lite;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_TEST);
use Util;

my $SERVICE = 'balance.greed_ts_paysys';
my $HOST    = 'greed-ts.paysys.yandex.ru';

my $PORT = 8002;

sub get_juggler_checks {
    my ($self) = @_;

    my $check = {
        service => $SERVICE,
        host    => $HOST,
        ttl     => '65m',
        tags    => [$ENV_TEST]
    };

    $self->add_wiki_meta_url($check,
        'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/greed-ts-paysys/');

    return [$check];
}

sub check {
    my ($self, $check, $pja) = @_;

    my $url = sprintf('http://%s:%d/xmlrpc', $check->{'host'}, $PORT);

    my $rpc = XMLRPC::Lite->new();
    $rpc->proxy($url, timeout => 60);

    my $som = $rpc->call('Balance2.FindClient', {PassportID => 155209804,},);

    my $success = 0;
    eval {
        my @result = $som->paramsall();
        $success = $result[0]->[2]->[0]->{CLIENT_ID} eq '2901607';
    };

    send_event($pja, $check, $success);
}

1;
