package Check::UnifiedAgentDrops;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use Carp;

use lib::abs qw(
  ../../lib
  );

use Constants qw ($ENV_PROD $ENV_TEST);
use Util;

my %HOSTS = (
    'partner-production-backend-services-stage' => {
        env     => $ENV_PROD,
        unit    => [qw(Services)],
        cluster => [qw(sas vla)],
    },
    'partner-test-backend-services-stage' => {
        env     => $ENV_TEST,
        unit    => [qw(Services)],
        cluster => [qw(sas vla)],
    },
    'partner-production-stage' => {
        env     => $ENV_PROD,
        unit    => [qw(Backend)],
        cluster => [qw(sas vla myt)]
    },
    'partner-test-stage' => {
        env     => $ENV_TEST,
        unit    => [qw(Backend)],
        cluster => [qw(sas vla)]
    }
);

sub get_juggler_checks {
    return [];
}

sub get_juggler_aggregator_checks {
    my ($self) = @_;

    my @checks;

    my $metric    = 'unified_agent_drops';
    my $wiki_page = $metric;
    $wiki_page =~ tr/_/-/;

    foreach my $stage (sort keys %HOSTS) {
        foreach my $unit (sort @{$HOSTS{$stage}{unit}}) {
            my $env   = $HOSTS{$stage}{env};
            my $check = {
                aggregator => 'logic_or',
                children   => [
                    map {
                        {
                            host    => sprintf('%s.%s@cluster=%s', $stage, $unit, $_),
                            service => "$metric.$env.$unit",
                            type    => 'YP_PODSET',
                        }
                      } sort @{$HOSTS{$stage}{cluster}}
                ],
                tags => [
                    ($env eq $ENV_PROD ? ($self->get_notification_tags(),) : ()),
                    $env
                ],
                refresh_time => 30,
                host         => $self->get_host_by_stage($env),
                service      => sprintf('%s.%s.%s_aggregator', $metric, $env, $unit),
                pronounce    => "На $stage.$unit java client unified агента дропает сообщения",
                ttl          => '90s',
            };

            $self->add_wiki_meta_url($check,
                "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/$wiki_page/");

            push(@checks, $check);
        }
    }

    return \@checks;
}

1;
