package Check::YaMoneyCert;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use base qw(Check);

use lib::abs qw(
  ../../lib
  );

use Constants qw ($DEPLOY_PROJECT_NAME @MAIN_STAGES);
use Util;

my $TTL = '103680s';

sub get_juggler_checks {
    my ($self) = @_;

    my $deploy_stages = $self->get_deploy_stages(stages => \@MAIN_STAGES, units => ['Backend']);

    my @checks = ();
    foreach my $stage (sort @MAIN_STAGES) {
        my $deploy_stage = $deploy_stages->{$stage};

        foreach my $dc (sort @{$deploy_stage->{'units'}{'Backend'}{'dcs'}}) {
            push(@checks, {
                aggregator => 'logic_or',
                children   => [
                    {
                        host    => sprintf('%s.Backend@cluster=%s', $stage, $dc),
                        service => 'yamoney-ssl',
                        type    => 'YP_PODSET'
                    }
                ],
                service    => "partner2_yamoney-ssl",
                host       => $self->get_host_by_deploy_stage($deploy_stage, dc => $dc),
                ttl        => $TTL,
                tags       => [$deploy_stage->{'env'}, $self->get_geo_tag_by_dc($deploy_stage->{'env'})],
            });
        }
    }

    return \@checks;
}

sub get_juggler_aggregator_checks {
    my ($self, $checks) = @_;

    my $check = {
        aggregator => 'logic_or',
        children   => [map {{service => $_->{'service'}, host => $_->{'host'}}} @$checks],
        service    => 'partner2_yamoney-ssl.aggregator',
        ttl        => $TTL,
        tags       => [$self->get_notification_tags()],
        pronounce  => "Необходимо обновить сертификат yamoney",
    };

    $self->add_wiki_meta_url($check,
        'https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/yamoney-ssl/');

    return [$check];
}

1;
