package Constants;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);

use JSON::XS qw();

our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(
    $DEFAULT_HOST
    $TEST_VIRTUAL_HOST
    $ENV_PROD
    $ENV_PROD_STAGE_FROM_PI_APPLICATION_JSON
    $ENV_PREPROD
    $ENV_TEST
    $ENV_DEV
    %ENV_TAGS
    $DEPLOY_HOSTS
    $DEPLOY_PROJECT_NAME
    @MAIN_STAGES
    $META_QYP_OR_HW_HOSTS
    $FALSE
    $TRUE
    $PARTNER2_ENDPOINTS
);

our $FALSE = $JSON::XS::false;
our $TRUE = $JSON::XS::true;

our $DEFAULT_HOST = 'partner-prod';
our $TEST_VIRTUAL_HOST = 'partner-test';

our $ENV_PROD = 'prod';
our $ENV_PROD_STAGE_FROM_PI_APPLICATION_JSON = 'production';
our $ENV_PREPROD = 'preprod';
our $ENV_TEST = 'test';
our $ENV_DEV = 'dev';

our %ENV_TAGS = (
    $ENV_PROD => 1,
    $ENV_PREPROD => 1,
    $ENV_TEST => 1,
    $ENV_DEV => 1,
);

our @MAIN_STAGES = qw(partner-preprod-stage partner-production-stage partner-test-stage);

our $PARTNER2_ENDPOINTS = [ '/devel/alive', '/v2/simple_alive', '/v2/alive', ];
my $PAGE_ID_GENERATOR_ENDPOINTS = [ '/alive' ];
my $FORM_ENDPOINTS = [ '/form/', '/form/api/0/alive' ];

our $DEPLOY_PROJECT_NAME = 'partner';
our $DEPLOY_HOSTS = {
    $ENV_PREPROD  => {
        'partner-preprod-stage.Backend' => {
            'dc'        => [ qw(iva vla) ],
            'endpoints' => $PARTNER2_ENDPOINTS
        },
        'partner-preprod-stage.Crons'   => {
            'dc'        => [ qw(vla) ],
        },
        'form-preprod.form'             => {
            'dc'        => [ qw(iva vla) ],
            'endpoints' => $FORM_ENDPOINTS,
        },
    },
    $ENV_PROD     => {
        'partner-production-stage.Backend' => {
            'dc'        => [ qw(myt sas vla) ],
            'endpoints' => $PARTNER2_ENDPOINTS
        },
        'partner-production-stage.Crons'   => {
            'dc'        => [ qw(myt sas vla) ],
        },
        'form-prod.form'                   => {
            'dc'        => [ qw(sas vla) ],
            'endpoints' => $FORM_ENDPOINTS,
        },

        'page-id-generator-prod.api'       => {
            'dc'        => [ qw(iva sas vla) ],
            'endpoints' => $PAGE_ID_GENERATOR_ENDPOINTS,
        }
    },
    $ENV_TEST     => {
        'partner-test-stage.Backend' => {
            'dc'        => [ qw(sas vla) ],
            'endpoints' => $PARTNER2_ENDPOINTS
        },
        'partner-test-stage.Crons'   => {
            'dc'        => [ qw(sas vla) ],
        },
        'form-test.form'             => {
            'dc'        => [ qw(myt) ],
            'endpoints' => $FORM_ENDPOINTS,
        },

        'page-id-generator-test.api' => {
            'dc'        => [ qw(iva) ],
            'endpoints' => $PAGE_ID_GENERATOR_ENDPOINTS,
        }
    },
};

our $META_QYP_OR_HW_HOSTS = [
    {
        host => 'dev-partner6.vla.yp-c.yandex.net',
        dc   => 'vla',
        env  => $ENV_DEV,
    },
    {
        host => 'dev-partner4.sas.yp-c.yandex.net',
        dc   => 'sas',
        env  => $ENV_DEV,
    },
    {
        host => 'dev-main1.sas.yp-c.yandex.net',
        dc   => 'sas',
        env  => $ENV_DEV,
    },
    {
        host => 'partner-creator1.sas.yp-c.yandex.net',
        dc   => 'sas',
        env  => $ENV_DEV,
    },
    {
        host => 'partner-creator2.vla.yp-c.yandex.net',
        dc   => 'sas',
        env  => $ENV_DEV,
    }
];

1;
