package CreateChecksAndRules;

use strict;
use warnings FATAL => 'all';
use utf8;
use open qw(:std :utf8);
use feature 'say';

use Carp;
use File::Find;

use lib::abs qw(
  ../lib
  );

use Util;
use File::Slurp;

my $VERSION_PATH    = '/tmp/create_checks.dump';

our $CHECKS_DIR     = lib::abs::path('../lib/Check');
my $NOTIFY_RULE_DIR = lib::abs::path('../lib/NotifyRule');

sub new {bless {}, __PACKAGE__}

sub create {
    my ($self, $pja, $dir, $base) = @_;

    my $logins = $pja->get_option('logins');

    my @files = ();

    find(
        sub {
            return if $_ eq '.';

            push(@files, $_);
        },
        $dir
    );

    my $error = 0;
    foreach my $file (sort @files) {
        require("$dir/$file");

        my $class = "${base}::$file";
        $class =~ s/\.pm$//;

        my $check = $class->new(logins => $logins);

        eval {$check->create($pja)};
        if ($@) {
            $error = 1;
            print STDERR "$@\n";
        }
    }

    return !$error;
}

sub run {
    my ($self) = @_;

    my $pja            = get_partner2_juggler_api();
    my $md5_hex_config = $pja->get_option('md5_hex_config');

    if (-e $VERSION_PATH) {
        my $version = read_file($VERSION_PATH);
        chomp($version);

        if ($version eq $md5_hex_config) {
            say 'Without changes... exit';
            return;
        }
    }

    my $checks_ok = $self->create($pja, $CHECKS_DIR, 'Check');
    my $notify_rules_ok = $self->create($pja, $NOTIFY_RULE_DIR, 'NotifyRule');

    write_file($VERSION_PATH, $md5_hex_config) if $checks_ok || $notify_rules_ok;
}



1;
